set terminal gif animate delay 5 enhanced font "Times,17" # gif出力をする準備

Tmax = 436                        # 合計データ数
dt = 1.0                          # 時間刻み幅
filename = "d_pendulum_log.txt"   # 読み込むファイルの指定
s = 3                             # point sizeの指定
t = 7                             # point typeの指定

set output "double_pendulum.gif"  # 出力ファイル名
set xrange [-2.5:2.5]
set yrange [-2.5:2.5]
set xlabel "x [m]"
set ylabel "y [m]"
set nokey                # 凡例の非表示
p_opt= "w lp ps s pt t"  # プロットオプションの設定 @文字列 で文字列の中身を展開できる
do for [n=0:Tmax-1] {
	set title sprintf("t = %d",n*dt)      # グラフ上部に時刻を表示
	p filename every :::n::n u 1:2 @p_opt # n個目のブロックをplotするようにeveryコマンドを使用。
	unset title
}
unset output # gif出力の終了