# pngターミナルにセットして、1280×960のpngファイルを出力する。フォントの大きさを14に調整する。
set terminal png size 1280,960 font ",14"

filename="gaussian.txt"		# 読み込みファイル名を変数に設定 
set output "gaussian.png"	# 出力ファイル名を変数に設定

# ------ x軸の設定 ---------------------------------------
set xrange [-5.5:5.5]		# x軸の描画範囲 
set xtics -5,1,5			# x軸の目盛り範囲
set xlabel "x"			# x軸のラベル名

# ------ y軸（左側：正規分布曲線のy軸）の設定 ---------------
set yrange [0:0.5]
set ytics  0,0.1,0.5 nomirror	# nomirrorで右側にy軸がミラーされないようにする。
set mytics 2
set ylabel "Gaussian"

# ------ y2軸（右側：累積分布関数（CDF）のy軸）の設定 -------
set y2range [0:1.1]
set y2tics 0,0.2,1 nomirror	# nomirrorで左側にy2軸がミラーされないようにする。
set y2label "CDF"

# データのプロットコマンド：CDFに対応するデータでは、axis x1y2とすることでy2軸を用いることを明記している。
p filename u 1:2 w lp title "Gaussian plot", "" u 1:3 w l axis x1y2 title "CDF"

unset output			# 出力終了